local assets =
{
    Asset("ANIM", "anim/treebox.zip"),
	Asset("ATLAS", "images/inventoryimages/treebox.xml")
	
	
}

local prefabs =
{
    "seeds",
}

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddMiniMapEntity()
    inst.entity:AddNetwork()

    inst.AnimState:SetBank("treebox")
    inst.AnimState:SetBuild("treebox")
    inst.AnimState:PlayAnimation("idle", true)

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
    inst:AddComponent("container")
    inst.components.container:WidgetSetup("treebox") 
    inst:AddComponent("inspectable")

    ---------------------        
    ---------------------   
	inst.entity:AddDynamicShadow()
	inst.DynamicShadow:SetSize( 4,4 )
	MakeObstaclePhysics(inst, .2)
	

    return inst
end

return Prefab("treebox", fn, assets, prefabs),
MakePlacer("treebox_placer", "treebox", "treebox", "idle")